package com.atlassian.bitbucket.ssh.command;

import javax.annotation.Nonnull;
import java.util.Optional;

/**
 * Describes a factory for parsing commands and creating {@link SshCommand} instances to run them.
 */
public interface SshCommandFactory {

    /**
     * @param context context describing the command, which can be used by the factory implementations to determine
     *                whether it supports the command or not
     * @return an {@link SshCommand} implementing the described command, which will be {@link Optional#empty empty}
     *         if the command is not {@link #supports supported}
     * @since 5.12
     */
    @Nonnull
    Optional<SshCommand> create(@Nonnull SshCommandContext context);

    /**
     * @param command the command from the remote client (e.g. "git-upload-pack path/to/repository")
     * @return {@code true} if this factory can create an {@link SshCommand} for the provided command;
     *         otherwise, {@code false} to try other factories
     */
    boolean supports(@Nonnull String command);
}
