package com.atlassian.bitbucket.ssh.command;

import java.io.IOException;

/**
 * Describes an SSH command, which can be run or canceled.
 */
public interface SshCommand {

    /**
     * Cancels a running command, usually in response to the SSH client disconnecting.
     */
    void cancel();

    /**
     * Runs the command, returning its exit code. {@code 0} (zero) indicates the command ran <i>successfully</i>,
     * and any other value (positive or negative) indicates failure.
     *
     * @return the result of the command, with {@code 0} meaning success and any other value meaning failure
     * @throws IOException may be thrown by implementations
     */
    int run() throws IOException;
}
