package com.atlassian.bitbucket.shutdown;

/**
 * Represents the status of component implementing {@link ShutdownHook}. This status is used during shutdown phase to
 * decide if the component is safe to terminate or not.
 *
 * @since 7.8
 */
public enum ShutdownHookStatus {

    /**
     * Indicates that the component has some currently running tasks which will be interrupted, if component is terminated.
     */
    ACTIVE,

    /**
     * Indicates that the component does not have any currently running tasks and hence safe to terminate.
     */
    IDLE
}