package com.atlassian.bitbucket.setting;

import com.atlassian.bitbucket.scope.Scope;

import javax.annotation.Nonnull;

/**
 * Handles validation of hook settings before they are persisted.
 * Validation errors will be returned to the user and displayed against the relevant field.
 * <p>
 * Example:
 * <pre>
 * public class MyValidator implements SettingsValidator {
 *     &#x0040;Override
 *     public void validate(Settings settings, SettingsValidationErrors errors, Scope scope {
 *          if (settings.getString("url", "").isEmpty()) {
 *              errors.addFieldError("url", "Url field is blank, please supply one"));
 *          }
 *     }
 * }
 * </pre>
 *
 * @since 5.2
 */
public interface SettingsValidator {

    /**
     * Validate the given {@code settings} before they are persisted.
     *
     * @param settings to be validated
     * @param errors   callback for reporting validation errors.
     * @param scope    the context {@code Repository} the settings will be associated with
     */
    void validate(@Nonnull Settings settings, @Nonnull SettingsValidationErrors errors, @Nonnull Scope scope);
}
