package com.atlassian.bitbucket.scm.ssh;

import com.atlassian.bitbucket.scm.AbstractScmRequestHandlerModuleDescriptor;
import com.atlassian.bitbucket.scm.Scm;
import com.atlassian.bitbucket.scm.ScmUrlFormatter;
import com.atlassian.plugin.module.ModuleFactory;

/**
 * Module descriptor for providing {@link SshScmRequestHandler} implementations.
 * <p>
 * Usage:
 * <pre><code>
 *     &lt;ssh-request-handler
 *              key="gitSshScmRequestHandler"
 *              class="com.example.stash.internal.scm.git.protocol.ssh.DefaultGitSshScmRequestHandler"
 *              scm="git"
 *              weight="100"&gt;
 *         &lt;url-formatter class="com.atlassian.stash.internal.scm.git.protocol.ssh.GitSshUrlFormatter"/&gt;
 *     &lt;/ssh-request-handler&gt;
 * </code></pre>
 * The {@code key} and {@code class} attributes are <b>required</b>. The {@code scm} and {@code weight} attributes,
 * and the nested {@code url-formatter}, are <i>optional</i>.
 * <ul>
 *     <li>{@code scm}: Indicates the {@link SshScmRequestHandler} being registered <i>adds</i> SSH support
 *     for the specified SCM. This value should match the {@link Scm#getId() ID} of
 *     the associated SCM.
 *     <ul>
 *         <li>The weighted nature of {@link SshScmRequestHandler handlers} means it's possible to add handlers
 *         which intercept other handlers, but do not, of themselves, add SSH support for an SCM</li>
 *         <li>For example, the SCM cache plugin uses this ability to introduce pack caching for Git, but, of
 *         itself, it does <i>not</i> add SSH support for Git; it relies on another plugin for that</li>
 *     </ul>
 *     </li>
 *     <li>{@code url-formatter}: Allows registering an {@link ScmUrlFormatter} which can be used to override
 *     the default SSH URL to apply SCM-specific decorators
 *     <ul>
 *         <li>If the {@code url-formatter} element is included, the {@code class} attribute is required</li>
 *     </ul>
 *     </li>
 *     <li>{@code weight}: Defines the order in which {@link SshScmRequestHandler} implementations will be
 *     queried. Lower weights are queried earlier and the default weight is 100. The first implementation
 *     that supports a given command will be used</li>
 * </ul>
 */
public class SshScmRequestHandlerModuleDescriptor
        extends AbstractScmRequestHandlerModuleDescriptor<SshScmRequestHandler> {

    public static final String XML_ELEMENT_NAME = "ssh-request-handler";

    public SshScmRequestHandlerModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory, 100);
    }
}
