package com.atlassian.bitbucket.scm.ssh;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;

import javax.annotation.Nonnull;
import java.util.Optional;

import static java.util.Optional.empty;

/**
 * Plugin point for handling {@link SshScmRequest}s.
 *
 * @see SshScmRequestHandlerModuleDescriptor
 */
public interface SshScmRequestHandler {

    /**
     * Returns an {@link SshScmRequest} if this handler can handle the supplied command string, or
     * {@link Optional#empty()} otherwise.
     *
     * @param context context describing the request, which can be used by the handler implementation to determine
     *                whether it supports the request or not
     * @return an {@link SshScmRequest} if this handler supports the specified command, or {@link Optional#empty()} to
     *         indicate that this factory does not support the command
     * @throws NoSuchRepositoryException if this handler supports the specified command, but the requested repository
     *                                   cannot be found
     * @throws AuthorisationException if this handler the repository is not accessible
     * @since 5.12
     */
    @Nonnull
    default Optional<SshScmRequest> create(@Nonnull SshScmRequestContext context) {
        return empty();
    }

    /**
     * @param command the command String passed from the remote SSH client (e.g. "git-upload-pack path/to/repository")
     * @return {@code true} if the handler supports the supplied command, {@code false} otherwise
     */
    boolean supports(@Nonnull String command);
}
