package com.atlassian.bitbucket.scm.ref;

import com.atlassian.bitbucket.repository.*;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.PluginCommandFactory;

import javax.annotation.Nonnull;

/**
 * Specialized command factory for dealing with {@link Ref refs}.
 *
 * @see PluginCommandFactory
 */
public interface PluginRefCommandFactory {

    /**
     * @param repository the repository to create the branch
     * @param parameters describes the parameters required to create a branch
     * @return a command which, when called, will create a branch
     * @throws InvalidAuthorException if an author is not provided and there is no current effective user
     */
    @Nonnull
    Command<Branch> createBranch(@Nonnull Repository repository, @Nonnull CreateBranchCommandParameters parameters);

    /**
     * @param repository the repository to create the tag
     * @param parameters describes the parameters required to create a tag
     * @return a command which, when called, will create a tag
     * @throws InvalidAuthorException if an author is not provided and there is no current effective user
     */
    @Nonnull
    Command<Tag> createTag(@Nonnull Repository repository, @Nonnull CreateTagCommandParameters parameters);
}
