package com.atlassian.bitbucket.scm.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

public class UpdatePullRequestRefsCommandParameters {

    private final Set<PullRequest> pullRequests;

    private UpdatePullRequestRefsCommandParameters(Builder builder) {
        pullRequests = builder.pullRequests.build();
    }

    @Nonnull
    public Set<PullRequest> getPullRequests() {
        return pullRequests;
    }

    public static class Builder extends BuilderSupport {

        private final ImmutableSet.Builder<PullRequest> pullRequests;

        public Builder() {
            pullRequests = ImmutableSet.builder();
        }

        @Nonnull
        public UpdatePullRequestRefsCommandParameters build() {
            return new UpdatePullRequestRefsCommandParameters(this);
        }

        @Nonnull
        public Builder pullRequests(@Nullable PullRequest value, @Nullable PullRequest... moreValues) {
            addIf(Objects::nonNull, pullRequests, value, moreValues);
            return this;
        }

        @Nonnull
        public Builder pullRequests(@Nullable Iterable<PullRequest> values) {
            addIf(Objects::nonNull, pullRequests, values);
            return this;
        }
    }
}
