package com.atlassian.bitbucket.scm.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Describes how a {@link com.atlassian.bitbucket.pull.PullRequest pull request} is going to be rescoped. As part of
 * pull request rescoping, the system will determine how a pull request needs to be rescoped and request the SCM to
 * analyse how these changes will affect the pull request.
 *
 * @see BulkRescopeContext for a detailed description
 *
 * @since 4.5
 */
public interface PullRequestRescope {

    /**
     * @return the repository the pull request is opened {@link PullRequest#getFromRef() from}
     */
    @Nonnull
    Repository getFromRepository();

    /**
     * @return the commit ID the {@link PullRequest#getFromRef() from-ref} is going to be changed to. A {@code null}
     *         value means that the ref was deleted.
     */
    @Nullable
    String getNewFromHash();

    /**
     * @return the commit ID the {@link PullRequest#getFromRef() to-ref} is going to be changed to. A {@code null}
     *         value means that the ref was deleted.
     */
    @Nullable
    String getNewToHash();

    /**
     * @return the commit ID the {@link PullRequest#getFromRef() from-ref} is changed from.
     */
    @Nonnull
    String getOldFromHash();

    /**
     * @return the commit ID the {@link PullRequest#getToRef() to-ref} is changed from.
     */
    @Nonnull
    String getOldToHash();

    /**
     * @return the pull request ID
     * @since 7.12
     */
    long getPullRequestId();

    /**
     * @return the repository the pull request is {@link PullRequest#getToRef() targeting}
     */
    @Nonnull
    Repository getToRepository();
}
