package com.atlassian.bitbucket.scm.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;

import javax.annotation.Nonnull;

/**
 * Describes a minimal {@link PullRequest pull request}, providing only the ID, version and
 * {@link PullRequestRef refs}.
 */
public interface MinimalPullRequest {

    /**
     * Retrieves the {@link PullRequestRef ref} that has been requested to be merged.
     *
     * @return the ref to be merged
     */
    @Nonnull
    PullRequestRef getFromRef();

    /**
     * Retrieves the pull request's ID, relative to the {@link #getToRef() target} {@link PullRequestRef#getRepository()
     * repository}.
     *
     * @return the pull request's ID
     */
    long getId();

    /**
     * Retrieves the {@link PullRequestRef ref} targeted for the merge, if the pull request is accepted.
     *
     * @return the merge target
     */
    @Nonnull
    PullRequestRef getToRef();

    /**
     * Retrieves the pull request's current version.
     *
     * @return the pull request's version
     */
    int getVersion();
}
