package com.atlassian.bitbucket.scm.pull;

import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeVeto;

import javax.annotation.Nonnull;
import java.util.Collection;

/**
 * A service that checks preconditions for pull request merges by applying {@link RepositoryMergeCheck}s, which can
 * be supplied by plugins, to determine whether merges should performed.
 */
public interface MergeRequestCheckService {

    /**
     * Applies all registered and enabled {@link RepositoryMergeCheck}s to determine if a pull request merge should
     * proceed. If any check {@link MergeRequest#veto(String, String) vetoes} the {@link MergeRequest} then the
     * merge should not be performed. A {@link PullRequestMergeVeto PullRequestMergeVeto} will be returned for
     * each failed check. If no checks veto the merge it should be allowed to proceed.
     *
     * @param pullRequest the pull request
     * @return a collection containing zero or more {@link PullRequestMergeVeto vetoes}, where an empty collection
     *         indicates the merge should be allowed to proceed
     */
    @Nonnull
    Collection<PullRequestMergeVeto> check(@Nonnull PullRequest pullRequest);
}
