package com.atlassian.bitbucket.scm.mirror;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.Command;

import javax.annotation.Nonnull;

/**
 * @since 4.1
 */
public interface PluginMirrorCommandFactory {

    /**
     * @param repository the repository to be synchronized
     * @param parameters describes where to synchronize from
     * @param callback callback to process synchronization results
     * @return the command
     */
    @Nonnull
    Command<Void> synchronize(@Nonnull Repository repository, @Nonnull MirrorSyncCommandParameters parameters,
                              @Nonnull MirrorSyncCallback callback);

    /**
     * Applies the provided {@link com.atlassian.bitbucket.repository.RefChange ref changes} in the repository. If one
     * or more of the updates cannot be performed (e.g. the toHash does not exist in the repository or the fromHash
     * does not match the current value in the repository), the command will apply all ref updates that can be safely
     * applied, then throw an exception.

     * @param repository the repository
     * @param parameters describes what ref changes to apply
     * @return the command
     * @since 4.2
     */
    @Nonnull
    Command<Void> updateRefs(@Nonnull Repository repository, @Nonnull MirrorUpdateRefsCommandParameters parameters);
}
