package com.atlassian.bitbucket.scm.integrity;

import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommandResult;

import javax.annotation.Nonnull;

/**
 * A Command factory for SCM integrity checks.
 *
 * @since 4.12
 */
public interface PluginIntegrityCheckCommandFactory {

    /**
     * Instructs an SCM to perform integrity checks. SCMs should use the {@link IntegrityCheckContext context}
     * to obtain additional information needed to perform checks. Inconsistencies should be reported
     * using the provided {@link IntegrityCheckCallback callback}.
     *
     * @param context  a context to be used to obtain additional information
     * @param callback a callback to report inconsistencies
     * @return a result indicating the status of the integrity check command, this is not to be confused
     *         with the results reported via the {@link IntegrityCheckCallback callback}.
     */
    @Nonnull
    Command<CommandResult> checkIntegrity(@Nonnull IntegrityCheckContext context,
                                          @Nonnull IntegrityCheckCallback callback);
}
