package com.atlassian.bitbucket.scm.integrity;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;
import java.util.OptionalLong;
import java.util.stream.Stream;

/**
 * Allows an SCM to obtain additional information required to perform integrity checks
 *
 * @since 4.12
 */
public interface IntegrityCheckContext {

    /**
     * Allows SCMs to obtain the highest / latest pull request found in the database
     *
     * @param repository the target repository
     * @return the {@link PullRequest#getId ID} of the latest pull request, or {@code empty()} if none have been created
     */
    @Nonnull
    OptionalLong getLatestPullRequestId(@Nonnull Repository repository);

    /**
     * Allows SCMs to request a {@link Stream stream} of repositories to check for consistency.
     * <p>
     * Note: This will only return {@link Repository repositories} that belong to the current SCM.
     *       SCMs implementations will not receive {@link Repository repositories}
     *       they do not support.
     *
     * @return a {@link Stream stream} of {@link Repository repository} instances.
     */
    @Nonnull
    Stream<Repository> getRepositories();
}
