package com.atlassian.bitbucket.scm.http;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

import static java.util.Objects.requireNonNull;

/**
 * Details about the HTTP request to be serviced.
 */
public class HttpRequestDetails {

    private final HttpServletRequest request;

    private HttpRequestDetails(HttpServletRequest request) {
        this.request = request;
    }

    public static HttpRequestDetails ofServletRequest(HttpServletRequest request) {
        return new HttpRequestDetails(request);
    }

    @Nullable
    public String getContentType() {
        return request.getContentType();
    }

    @Nullable
    public String getHeader(@Nonnull String name) {
        return request.getHeader(requireNonNull(name));
    }

    @Nonnull
    public String getMethod() {
        return request.getMethod();
    }

    @Nullable
    public String getPathInfo() {
        return request.getPathInfo();
    }

    @Nullable
    public String getParameter(@Nonnull String name) {
        return request.getParameter(requireNonNull(name));
    }
}
