package com.atlassian.bitbucket.scm.compare;

import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.compare.CompareRequest;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.PluginCommandFactory;
import com.atlassian.bitbucket.scm.pull.PluginPullRequestCommandFactory;

import javax.annotation.Nonnull;

/**
 * Specialized command factory to compare two refs.
 *
 * @see PluginCommandFactory
 * @see PluginPullRequestCommandFactory
 */
public interface PluginCompareCommandFactory {

    @Nonnull
    Command<Void> changes(@Nonnull CompareRequest compareRequest, @Nonnull CompareChangeCommandParameters parameters,
                          @Nonnull ChangeCallback callback);

    /**
     * @param compareRequest describes the refs being compared
     * @param callback       a callback to receive commits which are unique to the {@link CompareRequest#getFromRef
     *                       from ref}
     * @return a command which, when executed, will stream commits referenced by the {@link CompareRequest#getFromRef
     *         from ref} which are not referenced by the {@link CompareRequest#getToRef to ref}
     */
    @Nonnull
    Command<Void> commits(@Nonnull CompareRequest compareRequest, @Nonnull CommitCallback callback);

    @Nonnull
    Command<Void> diff(@Nonnull CompareRequest compareRequest, @Nonnull CompareDiffCommandParameters parameters,
                       @Nonnull DiffContentCallback callback);
}
