package com.atlassian.bitbucket.scm;

import javax.annotation.Nonnull;

/**
 * Implementation of the {@link Command} interface that provides empty implementations for all methods
 * except {@link #call()}.
 */
public abstract class SimpleCommand<T> implements Command<T> {

    @Nonnull
    @Override
    public AsyncCommand<T> asynchronous() {
        throw new UnsupportedOperationException();
    }

    /**
     * Throws an {@code UnsupportedOperationException} to indicate that an execution timeout cannot be configured.
     *
     * @param timeoutInSecs the maximum time the operation is allowed to run, in seconds
     * @throws UnsupportedOperationException if invoked
     */
    @Override
    public void setExecutionTimeout(long timeoutInSecs) {
        throw new UnsupportedOperationException();
    }

    /**
     * Throws an {@code UnsupportedOperationException} to indicate that an idle timeout cannot be configured.
     *
     * @param timeoutInSecs the maximum time the operation is allowed to be idle, in seconds
     * @throws UnsupportedOperationException if invoked
     */
    @Override
    public void setIdleTimeout(long timeoutInSecs) {
        throw new UnsupportedOperationException();
    }
}
