package com.atlassian.bitbucket.scm;

import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;

import static com.atlassian.plugin.util.validation.ValidationPattern.test;

/**
 * Parses the nested {@code url-formatter} element, when present, to produce an {@link ScmUrlFormatter}.
 */
public class ScmUrlFormatterModuleDescriptor extends AbstractModuleDescriptor<ScmUrlFormatter> {

    public ScmUrlFormatterModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    @Override
    public ScmUrlFormatter getModule() {
        return moduleFactory.createModule(moduleClassName, this);
    }

    @Override
    protected void provideValidationRules(ValidationPattern pattern) {
        //Don't call super.provideValidationRules here; "key" should not be required since URL
        //formatters are nested components
        pattern.rule(test("@class").withError("The url-formatter class attribute is required"));
    }
}
