package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.scm.http.HttpScmRequestHandler;
import com.atlassian.bitbucket.scm.ssh.SshScmRequestHandler;

import javax.annotation.Nonnull;
import java.net.URI;
import java.net.URISyntaxException;

/**
 * Formats an appropriate URL for a given {@link ScmUrlRequest#getRepository() repository}.
 * <p>
 * URL formatters are associated with specific SCM request handlers, which are associated with specific protocols:
 * <ul>
 *     <li>HTTP: {@link HttpScmRequestHandler HttpScmRequestHandler}</li>
 *     <li>SSH: {@link SshScmRequestHandler SshScmRequestHandler}</li>
 * </ul>
 * The formatted URL, which used by the associated {@link Scm SCM}, should produce a request
 * which the associated request handler will be able to process.
 */
public interface ScmUrlFormatter {

    /**
     * @param request a request describing the repository and base URL to use when formatting
     * @return the formatted URL, which may never be {@code null}
     * @throws URISyntaxException if URL formatting fails
     */
    @Nonnull
    URI format(@Nonnull ScmUrlRequest request) throws URISyntaxException;
}
