package com.atlassian.bitbucket.scm;

import java.io.IOException;

/**
 * Used to validate read and write operations on repositories managed by Stash. This should be used across all
 * repository serving end-points (e.g. HTTP, SSH) to ensure preconditions such as authentication and authorisation are
 * consistently applied and error condition messaging is consistent.
 *
 * Plugins may register additional validation hooks.
 *
 * @see ScmRequestCheck
 */
public interface ScmRequestCheckService {

    /**
     * Check whether the supplied {@link ScmRequest} can proceed within the current request and server context.
     *
     * @param request the scm action to vote on
     * @return true if the action is allowed, false otherwise
     * @throws IOException if the supplied request threw an exception when handling an error
     */
    boolean checkActionAllowed(ScmRequest request) throws IOException;
}
