package com.atlassian.bitbucket.scm;

import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;

import static com.atlassian.plugin.util.validation.ValidationPattern.test;

/**
 * Provides an {@link ScmRequestCheck} implementation used by the {@link ScmRequestCheckService}.
 *
 * <p>Usage example:</p>
 * <pre>
 *     &lt;scm-request-check
 *              key="throttleCheck"
 *              class="com.atlassian.bitbucket.internal.scm.check.ThrottleCheck"
 *              weight="20" /&gt;
 * </pre>
 *
 * <p>
 * The (optional) weight attribute defines the order in which {@link ScmRequestCheck} implementations will be queried.
 * Lower weights are queried earlier and the default weight is 10. If an earlier {@link ScmRequestCheck} vetoes an
 * {@link ScmRequest} subsequent checks will not be called.
 * </p>
 */
public class ScmRequestCheckModuleDescriptor extends BaseWeightedModuleDescriptor<ScmRequestCheck> {

    public static final String XML_ELEMENT_NAME = "scm-request-check";

    protected ScmRequestCheckModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory, 10);
    }

    @Override
    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(test("@class").withError("The class is required"));
    }

    @Override
    public ScmRequestCheck getModule() {
        return moduleFactory.createModule(moduleClassName, this);
    }

}
