package com.atlassian.bitbucket.scm;

import javax.annotation.Nonnull;
import java.io.IOException;

/**
 * Used to enforce a specific precondition for a repository hosting operation, such as a push or pull.
 *
 * @see ScmRequestCheckModuleDescriptor
 */
public interface ScmRequestCheck {

    /**
     * @param request the scm action to validate
     * @return true if the check passed, false if the check failed and the request should be terminated
     * @throws IOException if the supplied request threw an exception when handling an error
     */
    boolean check(@Nonnull ScmRequest request) throws IOException;
}
