package com.atlassian.bitbucket.scm;

import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;

/**
 * Provides an {@link ScmProtocol} implementation used in connection with one or more {@link Scm Scms}.
 *
 * <p>Usage example:</p>
 * <pre>
 *     &lt;scm-protocol
 *          key="ssh-protocol-for-git"
 *          weight="10"
 *          class="com.atlassian.stash.internal.scm.git.protocol.http.GitHttpProtocol"/&gt;
 * </pre>
 *
 * <p>
 * The (optional) weight attribute defines the order in which {@link ScmRequestCheck} implementations will be queried.
 * Lower weights are queried earlier and the default weight is 10.
 * </p>
 */
public class ScmProtocolModuleDescriptor extends AbstractModuleDescriptor<ScmProtocol> {

    public static final String XML_ELEMENT_NAME = "scm-protocol";

    private volatile ScmProtocol protocol;

    public ScmProtocolModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    @Override
    public void disabled() {
        protocol = null;
        super.disabled();
    }

    @Override
    public ScmProtocol getModule() {
        if (protocol == null) {
            protocol = moduleFactory.createModule(moduleClassName, this);
        }
        return protocol;
    }
}
