package com.atlassian.bitbucket.scm;

/**
 * Indicates the result of a user's authentication attempt.
 */
public enum AuthenticationState {

    /**
     * Indicates that authentication has succeeded.
     */
    AUTHENTICATED,

    /**
     * Indicates that authentication failed or no attempt to authenticate was made.
     */
    NOT_AUTHENTICATED,

    /**
     * Indicates that authentication succeeded but the user account is not licensed to use Stash.
     */
    UNLICENSED,

    /**
     * Indicates that the user's account is locked and they must navigate to the Stash Web UI and solve a CAPTCHA test.
     */
    CAPTCHA_REQUIRED

}
