package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Extends {@link AbstractScmRequest} and adds properties to facilitate implementing {@link ScmRequest SCM requests}
 * which interact with a repository, to read or {@link #isWrite() write}.
 */
public abstract class AbstractRepositoryScmRequest extends AbstractScmRequest {

    protected final Repository repository;
    protected final boolean write;

    protected AbstractRepositoryScmRequest(@Nonnull Repository repository, boolean write) {
        this.repository = requireNonNull(repository, "repository");
        this.write = write;
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return repository;
    }

    @Override
    public boolean isWrite() {
        return write;
    }
}
