package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;
import java.util.Map;

/**
 * A plugin point for associating arbitrary metadata with a {@link Ref}.
 * <p>
 * To define a {@code RefMetadataProvider} within your plugin you will need to implement this interface
 * and add the following to your atlassian-plugin.xml.
 * <pre>
 *     &lt;ref-metadata key="my-metadata-provider" class="com.example.MyMetadataProvider" /&gt;
 * </pre>
 *
 * @param <T> the type of the metadata
 * @see MetadataMap
 */
public interface RefMetadataProvider<T> {

    /**
     * @param context the context in which the metadata is being provided
     * @return a map of associated metadata, keyed by the associated {@link Ref}
     */
    @Nonnull
    Map<Ref, T> getMetadata(@Nonnull RefMetadataContext context);
}
