package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;
import java.util.Map;
import java.util.Set;

/**
 * The context in which the metadata is being retrieved for a given collection of {@link Ref refs}
 *
 * @see RefMetadataProvider
 */
public interface RefMetadataContext {

    /**
     * @return return a map of context attributes
     */
    @Nonnull
    Map<String, Object> getContext();

    /**
     * @return the base ref the refs should be compared to (for the providers that uses that information)
     */
    @Nonnull
    Ref getBaseRef();

    /**
     * @return the collection of {@link Ref refs} for which to fetch the metadata
     */
    @Nonnull
    Set<Ref> getRefs();

    /**
     * @return the repository the {@link Ref refs} are contained within
     */
    @Nonnull
    Repository getRepository();
}
