package com.atlassian.bitbucket.pull;

import javax.annotation.Nonnull;

/**
 * Provides properties to Stash {@link PullRequest pull requests}.
 * <p>
 * NOTE: Property values must be convertible to JSON (e.g. extend from {@code RestMapEntity}), or otherwise REST
 * requests to entities owning the properties will fail.
 *
 * @see PullRequestPropertyContext
 */
public interface PullRequestPropertyProvider {

    /**
     * Provide properties to the given {@code context}.
     *
     * @param context current pull request property context
     */
    void provideProperties(@Nonnull PullRequestPropertyContext context);
}
