package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.property.PropertyMap;

import javax.annotation.Nonnull;

/**
 * Allows iterating and adding {@link PropertyMap properties} to pull requests. This context is guaranteed to not
 * contain duplicate pull requests.
 */
public interface PullRequestPropertyContext extends Iterable<PullRequest> {

    /**
     * Adds a property to the {@code pullRequest}. Any existing property stored under {@code key} will be replaced.
     *
     * @param pullRequest the pull request that will receive the new property
     * @param key property key
     * @param value property value
     */
    void setProperty(@Nonnull PullRequest pullRequest, @Nonnull String key, @Nonnull Object value);
}
