package com.atlassian.bitbucket.pull;

import javax.annotation.Nonnull;
import java.util.Map;

/**
 * Provides properties to {@link PullRequestMergeability}.
 * <p>
 * NOTE: Property values must be convertible to JSON (e.g. extend from {@code RestMapEntity}), or otherwise REST
 * requests to entities owning the properties will fail.
 */
public interface PullRequestMergeabilityPropertyProvider {

    /**
     * Provide properties for the provided pull request and mergeability. Plugins should prefix property keys with a
     * unique identifier (e.g. the plugin key) to avoid conflicts.
     *
     * @param pullRequest the pull request
     * @param mergeability the pull request mergeability
     * @return a Map of properties to be added to {@code mergeability}. Can be empty, but not null.
     */
    @Nonnull
    Map<String, Object> provideProperties(@Nonnull PullRequest pullRequest, @Nonnull PullRequestMergeability mergeability);
}
