package com.atlassian.bitbucket.permission;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import org.dom4j.Element;

import javax.annotation.Nonnull;

/**
 * Module descriptor for providing {@link PermissionVoterProvider} implementations.
 * <p>
 * Usage:
 * <pre><code>
 *     &lt;permission-voter-provider
 *              key="customPermissionVoterProvider"
 *              class="com.example.bitbucket.internal.permission.DefaultPermissionVoterProvider"/&gt;
 * </code></pre>
 * The {@code key} and {@code class} attributes are <b>required</b>.
 *
 * @since 5.5
 */
public class PermissionVoterProviderModuleDescriptor extends AbstractModuleDescriptor<PermissionVoterProvider> {

    public static final String XML_ELEMENT_NAME = "permission-voter-provider";

    private volatile PermissionVoterProvider module;

    public PermissionVoterProviderModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    @Override
    public void disabled() {
        if (module instanceof StateAware) {
            ((StateAware) module).disabled();
        }
        module = null;

        super.disabled();
    }

    @Override
    public PermissionVoterProvider getModule() {
        if (module == null) {
            module = moduleFactory.createModule(moduleClassName, this);

        }
        return module;
    }

    @Override
    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
    }
}