package com.atlassian.bitbucket.permission;

import javax.annotation.Nonnull;

/**
 * A {@link PermissionVoter} may be used to determine access restrictions for application resources. For every
 * permission check the application performs, the vote() method of each known {@link PermissionVoter}
 * is invoked. For the permission check to succeed, at least one {@link PermissionVoter} must return a result of
 * {@link PermissionVote#GRANT}.  If any {@link PermissionVoter} returns a result of {@link PermissionVote#VETO}, the
 * permission check is unsuccessful and the user is not allowed to carry out the requested operation.
 * If a {@link PermissionVoter} does not explicitly allow or deny the permission, it should return a result of
 * {@link PermissionVote#ABSTAIN}.
 *
 * @since 5.5
 */
@FunctionalInterface
public interface PermissionVoter {

    @Nonnull
    PermissionVote vote(@Nonnull PermissionCheck permissionCheck);
}
