package com.atlassian.bitbucket.permission;

import javax.annotation.Nonnull;

/**
 * @since 5.5
 */
public enum PermissionVote {

    GRANT,
    VETO,
    ABSTAIN;

    @Nonnull
    public static PermissionVote resultOf(@Nonnull PermissionVote... votes) {
        PermissionVote result = PermissionVote.ABSTAIN;
        for (PermissionVote vote : votes) {
            if (vote == PermissionVote.VETO) {
                return PermissionVote.VETO;
            }
            if (vote == PermissionVote.GRANT) {
                result = PermissionVote.GRANT;
            }
        }
        return result;
    }
}
