package com.atlassian.bitbucket.permission;

import javax.annotation.Nonnull;
import java.util.Optional;

/**
 * The permission to check and optionally the resource on which to check it.
 * Note: The resource could be an ID referencing the resource, or the resource itself.
 *
 * @since 5.5
 */
public interface PermissionCheck {

    /**
     * @return The permission to check
     */
    @Nonnull
    Permission getPermission();

    /**
     * The resource that the permission check applies to. This could be empty if the requested permission is global if
     * the check is for permission on any resource.
     *
     * @return an optional resource representing the resource that the permission check is applied to
     */
    @Nonnull
    Optional<Object> getResource();

    /**
     * @return the (intermediate) result based on the {@link PermissionVoter voters} that have been consulted so far
     */
    @Nonnull
    PermissionVote getResult();
}
