package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.bitbucket.io.IoFunction;

import javax.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

/**
 * Provides access to a single file within an archive.
 *
 * @since 5.13
 */
public interface EntrySource {

    /**
     * Apply the {@link IoFunction} to the file represented by this entry and return the result.
     *
     * @param reader consumes the {@link InputStream} for this entry
     * @param <T> type of the return value
     * @return the value returned by <code>reader</code>
     * @throws IOException if an error was encountered while performing IO
     */
    <T> T apply(@Nonnull IoFunction<InputStream, T> reader) throws IOException;

    /**
     * Extract this entry to the specified target.
     *
     * @param target where this file will be copied
     * @throws IOException if an error was encountered while performing IO
     */
    void extractToDisk(@Nonnull Path target) throws IOException;

    /**
     * @return location of this entry within the archive
     */
    @Nonnull
    Path getPath();

    /**
     * Read the file represented by this entry.
     *
     * @param reader consumes the {@link InputStream} for this entry
     * @throws IOException if an error was encountered while performing IO
     */
    void read(@Nonnull IoConsumer<InputStream> reader) throws IOException;
}
