package com.atlassian.bitbucket.migration;

import javax.annotation.Nonnull;

/**
 * Provides the ability to map local IDs to instance agnostic logical IDs during an export.
 *
 * @since 5.13
 */
public interface EntityExportMapping<K> {

    /**
     * Given a local ID, calculate its corresponding export ID. The IDs generated are only guaranteed to be stable on
     * the same instance, i.e. given an ID '5' on instance A might yield a different value on instance B.
     *
     * @param id Local ID of the entity on this instance
     * @return Export ID of the entity
     */
    @Nonnull
    String getExportId(@Nonnull K id);
}
