package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Thrown during migration operations to signal the caller that the operation has been canceled and that the caller
 * should clean up the state they own and stop any work. Should always be re-thrown if caught.
 *
 * @since 5.13
 * @see ExportContext#abortIfCanceled()
 */
public class CanceledMigrationException extends ServiceException {

    public CanceledMigrationException(@Nonnull KeyedMessage message) {
        super(message);
    }
}
