package com.atlassian.bitbucket.json;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Map;

/**
 * Renders an object to a JSON string. Used by Stash when a JSON representation of a model
 * object is required, typically in its view layer. Service providers will not normally need to implement this interface.
 */
public interface JsonRenderer {

    /**
     * Renders an object to JSON given any supplied options. If the renderer does not know how to
     * render the supplied object to JSON or if an error is encountered while doing this then it should return null.
     *
     * @param object the object to render
     * @param options any options the renderer should take into consideration
     * @return null if unable to render the object to JSON
     */
    @Nullable String render(@Nullable Object object, @Nonnull Map<String, Object> options);
}
