package com.atlassian.bitbucket.io;

import java.io.IOException;

/**
 * @since 5.13
 */
@FunctionalInterface
public interface IoConsumer<T> {

    /**
     * Performs this operation on the given argument.
     *
     * @param t the input argument
     * @throws IOException if the operation fails
     */
    void accept(T t) throws IOException;
}
