package com.atlassian.bitbucket.io;

import java.io.IOException;

/**
 * @since 7.14
 */
@FunctionalInterface
public interface IoBiConsumer<T, U> {

    /**
     * Performs this operation on the given arguments.
     *
     * @param t the first input argument
     * @param u the second input argument
     * @throws IOException if the operation fails
     */
    void accept(T t, U u) throws IOException;
}
