package com.atlassian.bitbucket.idx;

import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;

/**
 * @see CommitPropertyConfiguration
 */
public class CommitPropertyConfigurationModuleDescriptor extends AbstractModuleDescriptor<CommitPropertyConfiguration> {

    public static final String XML_ELEMENT_NAME = "commit-property-config".intern();

    private volatile CommitPropertyConfiguration module;

    public CommitPropertyConfigurationModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    @Override
    public CommitPropertyConfiguration getModule() {
        return module;
    }

    @Override
    public void enabled() {
        super.enabled();
        module = moduleFactory.createModule(moduleClassName, this);
        if (module instanceof StateAware) {
            ((StateAware) module).enabled();
        }
    }

    public void disabled() {
        if (module instanceof StateAware) {
            ((StateAware) module).disabled();
        }
        module = null;
        super.disabled();
    }
}
