package com.atlassian.bitbucket.idx;

import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;
import java.util.Collection;

/**
 * Property configuration for any commit indexer.
 */
public interface CommitPropertyConfiguration {

    /**
     * @param repository the repository
     * @return a collection of property keys to preload on every commit request. Properties can be loaded
     * on demand via rest using the expand query string. They can also be fetched programatically via the
     * {@link CommitIndex}
     */
    @Nonnull
    Collection<String> getPropertiesToPreload(Repository repository);
}
