package com.atlassian.bitbucket.idx;

import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;

public class CommitIndexerModuleDescriptor extends AbstractModuleDescriptor<CommitIndexer> {

    public static final String XML_ELEMENT_NAME = "commit-indexer";

    private CommitIndexer module;

    public CommitIndexerModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    @Override
    public CommitIndexer getModule() {
        if (module == null) {
            module = moduleFactory.createModule(moduleClassName, this);
        }

        return module;
    }

    public void disabled() {
        if (module instanceof StateAware) {
            ((StateAware) module).disabled();
        }
        module = null;

        super.disabled();
    }
}
