package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.pull.PullRequestService;

/**
 * Used to enforce a specific precondition for a pull request merge operation.
 * <p>
 * Merge checks are called for:
 * <ul>
 *     <li>{@link PullRequestService#canMerge PullRequestService#canMerge}</li>
 *     <li>{@link PullRequestService#merge PullRequestService#merge}</li>
 * </ul>
 * {@link PullRequestMergeHookRequest#isDryRun} can be used to determine which operation is in progress, for
 * implementations which should only be applied to one or the other (but most checks should apply the same way to both).
 *
 * @since 5.0
 */
public interface RepositoryMergeCheck extends PreRepositoryHook<PullRequestMergeHookRequest> {
}
