package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.setting.Settings;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

public abstract class RepositoryHookContext {

    private final Settings settings;

    public RepositoryHookContext(@Nonnull Settings settings) {
        this.settings = requireNonNull(settings, "settings");
    }

    /**
     * @return the hook {@link Settings}. If the hook has not been configured, empty settings are returned.
     */
    @Nonnull
    public Settings getSettings() {
        return settings;
    }
}
