package com.atlassian.bitbucket.hook.repository;

/**
 * Describes the type of commit details a repository-hook {@link RepositoryHookCommitCallback callback} is interested
 * in.
 *
 * @see PreRepositoryHookContext#registerCommitCallback(PreRepositoryHookCommitCallback, RepositoryHookCommitFilter, RepositoryHookCommitFilter...)
 * @see PostRepositoryHookContext#registerCommitCallback(RepositoryHookCommitCallback, RepositoryHookCommitFilter, RepositoryHookCommitFilter...)
 *
 * @since 5.0
 */
public enum RepositoryHookCommitFilter {
    /**
     * Any commit added to any ref. Includes commits that were already present in the repository, but not yet referenced
     * by the branch or tag. Implies {@link #ADDED_TO_REPOSITORY}
     */
    ADDED_TO_ANY_REF,
    /**
     * Any new commit added to any ref. Does <em>not</em> include commits that were already present in the repository.
     *
     * @see CommitAddedDetails#isAddedToRepository()
     */
    ADDED_TO_REPOSITORY,
    /**
     * Any commit removed from any ref. Includes commits that were removed from the branch or tag, but are
     * referenced by other branches or tags. Implies {@link #REMOVED_FROM_REPOSITORY}
     */
    REMOVED_FROM_ANY_REF,
    /**
     * Any commit that is removed from the branch or tag and no longer referenced in the repository. Does <em>not</em>
     * include commits that remain referenced from other branches or tags.
     *
     * @see CommitRemovedDetails#isRemovedFromRepository()
     */
    REMOVED_FROM_REPOSITORY,
}
