package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.setting.Settings;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * {@link RepositoryHookContext} specialization that is provided to {@link PreRepositoryHook} hooks
 *
 * @since 5.0
 */
public abstract class PreRepositoryHookContext extends RepositoryHookContext {

    protected PreRepositoryHookContext(@Nonnull Settings settings) {
        super(settings);
    }

    /**
     * Registers a callback to receive more information about commits added or removed. See the documentation on
     * {@link PreRepositoryHookCommitCallback} for details about when the callback methods are called.
     * <p>
     * Note: hooks may only register callbacks during
     * {@link PreRepositoryHook#preUpdate(PreRepositoryHookContext, RepositoryHookRequest)}. If a callback is
     * registered at any other time, {@code false} is returned and the callback is ignored.
     *
     * @param callback the callback
     * @param filter the type of commit details the callback is interested in
     * @param moreFilters other types of commit details the callback is interested in
     * @return {@code true} if the callback was successfully registered, otherwise {@code false}. If {@code false}
     *         is returned here, the callback will <em>not</em> be called
     */
    public abstract boolean registerCommitCallback(@Nonnull PreRepositoryHookCommitCallback callback,
                                                   @Nonnull RepositoryHookCommitFilter filter,
                                                   @Nullable RepositoryHookCommitFilter... moreFilters);
}
