package com.atlassian.bitbucket.hook.repository;

import javax.annotation.Nonnull;

/**
 * Specialized callback that {@link PreRepositoryHook pre-hooks} can
 * {@link PreRepositoryHookContext#registerCommitCallback register} to receive commit-level details for the
 * requested change.
 * <p>
 * This callback receives commit details as described by {@link RepositoryHookCommitCallback}, but also provides a
 * {@link #getResult()} method that allows the hook to veto the requested change.
 * <p>
 * The {@link #getResult()} method will be called after {@link #onEnd()} has been called.
 *
 * @see PreRepositoryHook
 * @see PreRepositoryHookContext
 * @since 5.0
 */
public interface PreRepositoryHookCommitCallback extends RepositoryHookCommitCallback {

    /**
     * Returns the outcome of the callback's processing of commits. This method will be called after {@link #onEnd()}
     * has been called.
     *
     * @return the outcome of the callback's processing of commits
     */
    @Nonnull
    RepositoryHookResult getResult();
}
