package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.repository.Ref;

import javax.annotation.Nonnull;

/**
 * Hook that is called for all veto-able changes to 1 or more Refs. Examples are: pushes, pull request merges, branch
 * creation/deletion through the REST API, file-edit, etc.
 *
 * @since 5.0
 */
public interface PreRepositoryHook<T extends RepositoryHookRequest> {

    /**
     * Callback method that is called just before a request to update one or more {@link Ref refs} is completed.
     *
     * @param context  provides hook settings and provides a way to obtain the commits added/removed
     * @param request  provides the refs that are about to be updated.
     * @return the outcome of the repository hook
     */
    @Nonnull
    RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull T request);

    /**
     * Callback method that is called after all registered and enabled hooks have been called
     *
     * @param context  provides hook settings and a way to obtain the commits added/removed
     * @param request  the change request
     * @param result   the combined outcome of all hooks that have been called, containing all vetoes returned by any
     *                 of the hooks
     */
    default void onEnd(@Nonnull PreRepositoryHookContext context, @Nonnull T request,
                       @Nonnull RepositoryHookResult result) {
    }
}
