package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.setting.Settings;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * {@link RepositoryHookContext} specialization that is provided to {@link PostRepositoryHook} hooks
 *
 * @since 5.0
 */
public abstract class PostRepositoryHookContext extends RepositoryHookContext {

    private final boolean synchronous;

    protected PostRepositoryHookContext(@Nonnull Settings settings, boolean synchronous) {
        super(settings);

        this.synchronous = synchronous;
    }

    /**
     * @return {@code true} if the hook is invoked synchronously, for instance as part of a
     *         {@link StandardRepositoryHookTrigger#REPO_PUSH push} to the repository. Only hooks annotated with
     *         {@link SynchronousPreferred} will be invoked synchronously.
     * @see SynchronousPreferred
     */
    public boolean isSynchronous() {
        return synchronous;
    }

    /**
     * Registers a callback to receive more information about commits added or removed. See the documentation on
     * {@link RepositoryHookCommitCallback} for details about when the callback methods are called.
     *
     * @param callback the callback
     * @param filter the type of commit details the callback is interested in
     * @param moreFilters other types of commit details the callback is interested in
     * @return {@code true} if the callback was successfully registered, otherwise {@code false}. If {@code false}
     *         is returned here, the callback will <em>not</em> be called
     */
    public abstract boolean registerCommitCallback(@Nonnull RepositoryHookCommitCallback callback,
                                                   @Nonnull RepositoryHookCommitFilter filter,
                                                   @Nullable RepositoryHookCommitFilter... moreFilters);
}
